-- Project Zomboid — Detailed Skill Tooltips
-- Skill: Cooking (Build 42.x; includes 42.12 UI note)
--
-- Shown stats (documented):
--   • Ingredient Used %
--   • Nutrition bonus per ingredient (% over base)
--   • Rotten ingredient allowance (L7+)
--   • Poison detection rule (L3..L9 up to Level N, L10 any)
--   • Add-ingredient action time reduction (−0.05s × level)
--   • 42.12: "Cooking time displayed on tooltips" (L5+)
--
-- No empirical behavior in this file.

require "API/DST_API"
require "API/DST_Helpers"

local DST = rawget(_G, "DST") or {}
local ST  = DST and DST.SkillTooltips
if not ST then return end

local KEY = "Cooking"

ST.addContributor(KEY, function(ctx)
    local lvl = ctx.getLevel()

    ctx.addHeader(ST.getText("IGUI_DST_Core_hdr"))

    -- Ingredient used %
    local pctUse = 100 - 3 * lvl
    ctx.add(ST.getText("IGUI_DST_Cooking_val_IngredientUse", tostring(pctUse)))

    -- Nutrition bonus (diminishing returns, saturates at +17%)
    local bonus = 2 * lvl + 1
    if lvl >= 2 then bonus = bonus + 2 end   -- step(lvl >= 2)
    if lvl >= 7 then bonus = bonus - 1 end   -- step(lvl >= 7)
    if bonus > 17 then bonus = 17 end
    ctx.add(ST.getText("IGUI_DST_Cooking_val_NutritionBonus", tostring(bonus)))

    -- Add-time (linear)
    local seconds = 0.05 * lvl
    ctx.add(ST.getText("IGUI_DST_Cooking_val_AddTime", DST.Helpers.formatSeconds(seconds)))

    -- Poison detection
    if lvl > 2 and lvl < 10 then
        ctx.add(ST.getText("IGUI_DST_Cooking_val_PoisonDetectUpto", tostring(lvl - 3)))
    elseif lvl >= 10 then
        ctx.add(ST.getText("IGUI_DST_Cooking_val_PoisonDetectAll"))
    end

    -- 42.12 note (L5+)
    if lvl >= 5 then
        ctx.add(ST.getText("IGUI_DST_Cooking_note_CookTimeL5"))
    end

    -- Rotten ingredients (L7+)
    local rotten = (lvl >= 9) and 10 or ((lvl >= 7) and 5 or 0)
    if rotten > 0 then
        ctx.add(ST.getText("IGUI_DST_Cooking_val_RottenAllowed", tostring(rotten)))
    end
end)

ST.addAutoLearnRecipes(KEY)
ST.addUnlockCraftRecipes(KEY)
ST.addUnlockBuildRecipes(KEY)
